<!-- Import -->
<div class="panel import-panel">
    <div class="postbox">
        <h3 class="hndle"><?php _e( 'Import', 'wp-simple-seo' ); ?></h3>

        <div class="option">
            <p class="description">
                <?php _e( 'Upload a JSON file generated by this Plugin\'s export functionality.  This will overwrite any existing settings stored on this installation.', 'wp-simple-seo' ); ?>
            </p>
        </div>

        <div class="option">
            <div class="left">
                <strong><?php _e( 'JSON File', 'wp-simple-seo' ); ?></strong>
            </div>
            <div class="right">
                <input type="file" name="import" />
                <br />
                <input name="submit" type="submit" class="button button-primary" value="<?php _e( 'Import', 'wp-simple-seo' ); ?>" />              
            </div>
        </div>
    </div>
</div>

<?php
// Iterate through import sources, outputting a view for each
if ( count( $screen['data']['import_sources'] ) > 0 ) {
    foreach ( $screen['data']['import_sources'] as $import_source ) {
        ?>
        <div class="panel import-<?php echo $import_source['name']; ?>-panel">
            <div class="postbox">
                <h3 class="hndle"><?php echo sprintf( __( 'Import from %s', 'wp-simple-seo' ), $import_source['label'] ); ?></h3>

                <div class="option">
                    <p class="description">
                        <?php echo sprintf( __( 'Imports %s data found on this WordPress installation. This will overwrite any existing settings in this Plugin.', 'wp-simple-seo' ), $import_source['label'] ); ?>
                    </p>
                </div>

                <div class="option">
                    <input name="import_<?php echo $import_source['name']; ?>" type="submit" class="button button-primary" value="<?php _e( 'Import', 'wp-simple-seo' ); ?>" />
                </div>
            </div>
        </div>
        <?php
    }
}
?>

<!-- Export -->
<div class="panel export-panel">
    <div class="postbox">
        <h3 class="hndle"><?php _e( 'Export', 'wp-simple-seo' ); ?></h3>

        <div class="option">
            <p class="description">
                <?php _e( 'To export this Plugin\'s settings, click the Export button below.', 'wp-simple-seo' ); ?>
                <br ?>
                <?php _e( 'You can then import the generated JSON file into another Plugin installation.', 'wp-simple-seo' ); ?>
            </p>
        </div>

        <div class="option">
            <a href="admin.php?page=wp-simple-seo-import-export&export=1" class="button button-primary" title="<?php _e( 'Export', 'wp-simple-seo' ); ?>">
                <?php _e( 'Export', 'wp-simple-seo' ); ?>
            </a>
        </div>
    </div>
</div>